/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters;

import com.github.L_Ender.cataclysm.client.particle.Options.RingParticleOptions;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.AI.SimpleAnimationGoal;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.LLibrary_Boss_Monster;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.etc.CMBossInfoServer;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.projectile.Ancient_Desert_Stele_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.EarthQuake_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import com.github.L_Ender.lionfishapi.server.animation.LegSolver;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class Ancient_Ancient_Remnant_Entity
extends LLibrary_Boss_Monster {
    public static final Animation REMNANT_BITE1 = Animation.create((int)61);
    public static final Animation REMNANT_BITE2 = Animation.create((int)67);
    public static final Animation REMNANT_CHARGE_PREPARE = Animation.create((int)125);
    public static final Animation REMNANT_TAIL_ATTACK1 = Animation.create((int)57);
    public static final Animation REMNANT_TAIL_ATTACK2 = Animation.create((int)55);
    public static final Animation REMNANT_LEFT_STOMP = Animation.create((int)47);
    public static final Animation REMNANT_RIGHT_STOMP = Animation.create((int)47);
    public static final Animation REMNANT_LEFT_STOMP_EXTRA = Animation.create((int)38);
    public static final Animation REMNANT_RIGHT_STOMP_EXTRA = Animation.create((int)38);
    public static final Animation REMNANT_ROAR = Animation.create((int)70);
    public static final Animation REMNANT_ROAR2 = Animation.create((int)100);
    public static final Animation REMNANT_PHASE_ROAR = Animation.create((int)100);
    public static final Animation REMNANT_TAIL_THREE = Animation.create((int)104);
    public static final Animation REMNANT_DEATH = Animation.create((int)158);
    private static final EntityDataAccessor<Boolean> CHARGE = SynchedEntityData.defineId(Ancient_Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ACT = SynchedEntityData.defineId(Ancient_Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> POWER = SynchedEntityData.defineId(Ancient_Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final LegSolver legSolver = new LegSolver(new LegSolver.Leg[]{new LegSolver.Leg(0.0f, 0.75f, 4.0f, false), new LegSolver.Leg(0.0f, -0.75f, 4.0f, false)});
    private AttackMode mode = AttackMode.CIRCLE;
    public float chargeProgress;
    public float prevchargeProgress;
    public float activeProgress;
    public float prevactiveProgress;
    private int hunting_cooldown = 160;
    private int charge_cooldown = 0;
    private int roar_cooldown = 0;
    private int roar2_cooldown = 0;
    private int earthquake_cooldown = 0;
    private int stomp_cooldown = 0;
    public static final int CHARGE_COOLDOWN = 250;
    public static final int ROAR_COOLDOWN = 500;
    public static final int ROAR2_COOLDOWN = 200;
    public static final int EARTHQUAKE_COOLDOWN = 160;
    public static final int STOMP_COOLDOWN = 200;
    private final CMBossInfoServer bossEvent = new CMBossInfoServer(this.getDisplayName(), BossEvent.BossBarColor.WHITE, false, 7);
    public static final int NATURE_HEAL_COOLDOWN = 200;
    private int timeWithoutTarget;
    public int frame;
    public static final int MINE_COOLDOWN = 100;

    public Ancient_Ancient_Remnant_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.xpReward = 500;
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        Ancient_Ancient_Remnant_Entity.setConfigattribute((LivingEntity)this, CMConfig.AncientRemnantHealthMultiplier, CMConfig.AncientRemnantDamageMultiplier);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, REMNANT_BITE1, REMNANT_CHARGE_PREPARE, REMNANT_BITE2, REMNANT_TAIL_ATTACK1, REMNANT_TAIL_ATTACK2, REMNANT_LEFT_STOMP, REMNANT_RIGHT_STOMP, REMNANT_ROAR, REMNANT_TAIL_THREE, REMNANT_ROAR2, REMNANT_LEFT_STOMP_EXTRA, REMNANT_RIGHT_STOMP_EXTRA, REMNANT_PHASE_ROAR, REMNANT_DEATH};
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RemnantAttackGoal(this));
        this.goalSelector.addGoal(0, (Goal)new AwakenGoal());
        this.goalSelector.addGoal(1, (Goal)new RemnantChargeAttackGoal(this, REMNANT_CHARGE_PREPARE));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_BITE1, 29));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_BITE2, 25));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_LEFT_STOMP, 24));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_RIGHT_STOMP, 24));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_LEFT_STOMP_EXTRA, 19));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_RIGHT_STOMP_EXTRA, 19));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_ATTACK1, 13));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_ATTACK2, 11));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_ROAR, 11));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_THREE, 20));
        this.goalSelector.addGoal(1, (Goal)new RemnantSteleAttackGoal(this, REMNANT_ROAR2, 29));
        this.goalSelector.addGoal(1, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_PHASE_ROAR, 29));
        this.goalSelector.addGoal(1, new SimpleAnimationGoal<Ancient_Ancient_Remnant_Entity>(this, REMNANT_DEATH));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 120, true, true, ModEntities.buildPredicateFromTag(ModTag.ANCIENT_REMNANT_TARGET)));
    }

    public static AttributeSupplier.Builder ancient_remnant() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 70.0).add(Attributes.MOVEMENT_SPEED, (double)0.33f).add(Attributes.ATTACK_DAMAGE, 25.0).add(Attributes.MAX_HEALTH, 400.0).add(Attributes.ARMOR, 10.0).add(Attributes.STEP_HEIGHT, 1.5).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean canBeSeenAsEnemy() {
        return this.getIsAct() && super.canBeSeenAsEnemy();
    }

    public ItemEntity spawnAtLocation(ItemStack stack) {
        ItemEntity itementity = this.spawnAtLocation(stack, 0.0f);
        if (itementity != null) {
            itementity.setGlowingTag(true);
            itementity.setExtendedLifetime();
        }
        return itementity;
    }

    @Override
    public boolean hurt(DamageSource source, float damage) {
        double range = this.calculateRange(source);
        if (this.getAnimation() == REMNANT_PHASE_ROAR && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (range > CMConfig.AncientRemnantLongRangelimit * CMConfig.AncientRemnantLongRangelimit && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        Entity entity = source.getDirectEntity();
        if (entity instanceof AbstractArrow) {
            return false;
        }
        if (this.activeProgress > 0.0f && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        return super.hurt(source, damage);
    }

    @Override
    public float DamageCap() {
        return (float)CMConfig.AncientRemnantDamageCap;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326229_) {
        super.defineSynchedData(p_326229_);
        p_326229_.define(CHARGE, (Object)false);
        p_326229_.define(IS_ACT, (Object)true);
        p_326229_.define(POWER, (Object)false);
    }

    public void setIsAct(boolean isAct) {
        this.entityData.set(IS_ACT, (Object)isAct);
    }

    public boolean getIsAct() {
        return (Boolean)this.entityData.get(IS_ACT);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Is_Act", this.getIsAct());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setIsAct(compound.getBoolean("Is_Act"));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void setIsCharge(boolean isAnger) {
        this.entityData.set(CHARGE, (Object)isAnger);
    }

    public boolean getIsCharge() {
        return (Boolean)this.entityData.get(CHARGE);
    }

    public void setIsPower(boolean isPower) {
        this.entityData.set(POWER, (Object)isPower);
    }

    public boolean getIsPower() {
        return (Boolean)this.entityData.get(POWER);
    }

    public boolean canStandOnFluid(FluidState p_204067_) {
        return p_204067_.is(FluidTags.WATER);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private void floatRemnant() {
        if (this.isInWater()) {
            CollisionContext collisioncontext = CollisionContext.of((Entity)this);
            if (collisioncontext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.WATER)) {
                this.setOnGround(true);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.prevchargeProgress = this.chargeProgress;
        this.prevactiveProgress = this.activeProgress;
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.getIsCharge() && this.chargeProgress < 3.0f) {
            this.chargeProgress += 1.0f;
        }
        if (!this.getIsCharge() && this.chargeProgress > 0.0f) {
            this.chargeProgress -= 1.0f;
        }
        if (!this.getIsAct() && this.activeProgress < 20.0f) {
            this.activeProgress += 1.0f;
        }
        if (this.getIsAct() && this.activeProgress > 0.0f) {
            this.activeProgress -= 1.0f;
        }
        this.legSolver.update((LivingEntity)this, this.yBodyRot, this.getScale());
        if (this.hunting_cooldown > 0) {
            --this.hunting_cooldown;
        }
        if (this.charge_cooldown > 0) {
            --this.charge_cooldown;
        }
        if (this.roar_cooldown > 0) {
            --this.roar_cooldown;
        }
        if (this.roar2_cooldown > 0) {
            --this.roar2_cooldown;
        }
        if (this.earthquake_cooldown > 0) {
            --this.earthquake_cooldown;
        }
        if (this.stomp_cooldown > 0) {
            --this.stomp_cooldown;
        }
        LivingEntity target = this.getTarget();
        if (!this.level().isClientSide) {
            if (this.timeWithoutTarget > 0) {
                --this.timeWithoutTarget;
            }
            if (target != null) {
                this.timeWithoutTarget = 200;
            }
            if (this.getAnimation() == NO_ANIMATION && this.timeWithoutTarget <= 0 && !this.isNoAi() && CMConfig.AncientRemnantNatureHealing > 0.0 && this.tickCount % 20 == 0) {
                this.heal((float)CMConfig.AncientRemnantNatureHealing);
            }
        }
        if (this.getIsPower() && this.tickCount % 20 == 0) {
            this.heal(2.0f);
        }
        this.floatRemnant();
        this.Charge();
        ++this.frame;
        float moveX = (float)(this.getX() - this.xo);
        float moveZ = (float)(this.getZ() - this.zo);
        float speed = Mth.sqrt((float)(moveX * moveX + moveZ * moveZ));
        if (!this.isSilent() && this.frame % 8 == 1 && (double)speed > 0.05 && this.getIsCharge() && this.onGround()) {
            this.playSound((SoundEvent)ModSounds.REMNANT_CHARGE_STEP.get(), 1.0f, 1.0f);
            ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
        }
        if (this.isAlive() && this.getIsAct() && !this.isNoAi() && this.getAnimation() == NO_ANIMATION && this.isPower() && !this.getIsPower()) {
            this.setAnimation(REMNANT_PHASE_ROAR);
        }
    }

    public boolean isPower() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    private void Charge() {
        if (this.getIsCharge()) {
            if (!this.level().isClientSide) {
                if (CMConfig.AncientRemnantBlockBreaking) {
                    this.ChargeBlockBreaking();
                } else if (EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
                    this.ChargeBlockBreaking();
                }
            }
            if (this.tickCount % 4 == 0) {
                for (LivingEntity Lentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.5))) {
                    boolean flag;
                    if (this.isAlliedTo((Entity)Lentity) || Lentity instanceof Ancient_Ancient_Remnant_Entity || Lentity == this || !(flag = Lentity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)((double)((float)this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 1.5f) + Math.min(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 1.5, (double)Lentity.getMaxHealth() * CMConfig.RemnantChargeHpDamage)))) || !Lentity.onGround()) continue;
                    double d0 = Lentity.getX() - this.getX();
                    double d1 = Lentity.getZ() - this.getZ();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    float f = 1.5f;
                    Lentity.push(d0 / d2 * (double)f, 0.5, d1 / d2 * (double)f);
                }
            }
        }
    }

    private void ChargeBlockBreaking() {
        boolean flag = false;
        AABB aabb = this.getBoundingBox().inflate(0.5, 0.2, 0.5);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)this.getY()), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (blockstate.isAir() || !blockstate.canEntityDestroy((BlockGetter)this.level(), blockpos, (Entity)this) || blockstate.is(ModTag.REMNANT_IMMUNE) || !EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
            if (this.random.nextInt(6) == 0 && !blockstate.hasBlockEntity()) {
                Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.level(), (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, blockstate, 20);
                flag = this.level().destroyBlock(blockpos, false, (Entity)this) || flag;
                fallingBlockEntity.setDeltaMovement(fallingBlockEntity.getDeltaMovement().add(this.position().subtract(fallingBlockEntity.position()).multiply((-1.2 + this.random.nextDouble()) / 3.0, 0.2 + this.getRandom().nextGaussian() * 0.15, (-1.2 + this.random.nextDouble()) / 3.0)));
                this.level().addFreshEntity((Entity)fallingBlockEntity);
                continue;
            }
            flag = this.level().destroyBlock(blockpos, false, (Entity)this) || flag;
        }
    }

    public void aiStep() {
        float ds;
        int l;
        super.aiStep();
        if (this.getAnimation() == REMNANT_BITE1) {
            if (this.getAnimationTick() == 5) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BITE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 28) {
                this.AreaAttack(8.0f, 8.0f, 70.0f, 1.35f, (float)CMConfig.RemnantHpDamage, 160, 0);
            }
        }
        if (this.getAnimation() == REMNANT_BITE2) {
            if (this.getAnimationTick() == 1) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BITE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 24) {
                this.AreaAttack(8.0f, 8.0f, 70.0f, 1.35f, (float)CMConfig.RemnantHpDamage, 160, 0);
            }
        }
        if (this.getAnimation() == REMNANT_TAIL_ATTACK1) {
            if (this.getAnimationTick() == 3) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_TAIL_SWING.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            if (this.getAnimationTick() == 16) {
                this.TailAreaAttack(8.0f, 8.0f, 1.05f, 120.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 200, 100);
            }
        }
        if (this.getAnimation() == REMNANT_TAIL_ATTACK2) {
            if (this.getAnimationTick() == 1) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_TAIL_SWING.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            if (this.getAnimationTick() == 14) {
                this.TailAreaAttack(8.0f, 8.0f, 1.05f, 120.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 200, 100);
            }
        }
        if (this.getAnimation() == REMNANT_CHARGE_PREPARE) {
            if (this.getAnimationTick() == 1) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_CHARGE_PREPARE.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 15) {
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.StompParticle(-0.1f, -0.75f);
            }
            if (this.getAnimationTick() == 41) {
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.StompParticle(-0.1f, 0.75f);
            }
            if (this.getAnimationTick() == 62) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_CHARGE_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 132) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BREATHING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == REMNANT_ROAR) {
            if (this.getAnimationTick() == 14) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 60);
            }
            if (this.getAnimationTick() == 55) {
                for (int i = 0; i < 4; ++i) {
                    float angle = (float)i * (float)Math.PI / 2.0f;
                    double sx = this.getX() + (double)(Mth.cos((float)angle) * 8.0f);
                    double sy = this.getY();
                    double sz = this.getZ() + (double)(Mth.sin((float)angle) * 8.0f);
                    if (this.level().isClientSide()) continue;
                    Sandstorm_Entity projectile = new Sandstorm_Entity(this.level(), sx, sy, sz, 300, angle, (LivingEntity)this);
                    this.level().addFreshEntity((Entity)projectile);
                }
            }
        }
        if (this.getAnimation() == REMNANT_ROAR2 && this.getAnimationTick() == 23) {
            ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 60);
            this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
        }
        if (this.getAnimation() == REMNANT_PHASE_ROAR && this.getAnimationTick() == 23) {
            ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 60);
            this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            this.setIsPower(true);
        }
        if (this.getAnimation() == REMNANT_TAIL_THREE) {
            if (this.getAnimationTick() == 1) {
                this.level().playSound((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_TAIL_SLAM.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 37) {
                this.AreaAttack(10.0f, 10.0f, 50.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 160, 0);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.EarthQuakeSummon(5.5f, 20 + this.random.nextInt(10), -0.75f);
            }
            if (this.getAnimationTick() == 55) {
                this.AreaAttack(10.0f, 10.0f, 50.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 160, 0);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.EarthQuakeSummon(5.5f, 20 + this.random.nextInt(10), -0.75f);
            }
            if (this.getAnimationTick() == 73) {
                this.AreaAttack(10.0f, 10.0f, 50.0f, 1.0f, (float)CMConfig.RemnantHpDamage, 160, 0);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.EarthQuakeSummon(5.5f, 20 + this.random.nextInt(10), -0.75f);
            }
        }
        if (this.getAnimation() == REMNANT_LEFT_STOMP) {
            if (this.getAnimationTick() == 28) {
                this.StompParticle(0.9f, 1.3f);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.playSound((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
                if (this.getIsPower()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, REMNANT_LEFT_STOMP_EXTRA);
                }
            }
            for (l = 28; l <= 45; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 26;
                int d2 = l - 25;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, 1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_LEFT_STOMP_EXTRA) {
            for (l = 2; l <= 19; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d2 = l + 1;
                float ds2 = (float)(l + d2) / 2.0f;
                this.StompDamage(0.4f, l, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds2, 1.3f);
            }
            if (this.getAnimationTick() == 19) {
                this.StompParticle(0.9f, 1.3f);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.playSound((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
            }
            for (l = 19; l <= 36; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 17;
                int d2 = l - 16;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, 1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, 1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_RIGHT_STOMP) {
            if (this.getAnimationTick() == 28) {
                this.StompParticle(0.9f, -1.3f);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.playSound((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
                if (this.getIsPower()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, REMNANT_RIGHT_STOMP_EXTRA);
                }
            }
            for (l = 28; l <= 45; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 26;
                int d2 = l - 25;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, -1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_RIGHT_STOMP_EXTRA) {
            for (l = 2; l <= 19; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d2 = l + 1;
                float ds3 = (float)(l + d2) / 2.0f;
                this.StompDamage(0.4f, l, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, -1.3f, 80, 0.85f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds3, -1.3f);
            }
            if (this.getAnimationTick() == 19) {
                this.StompParticle(0.9f, -1.3f);
                ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.1f, 0, 10);
                this.playSound((SoundEvent)ModSounds.REMNANT_STOMP.get(), 1.0f, 1.0f);
            }
            for (l = 19; l <= 36; l += 2) {
                if (this.getAnimationTick() != l) continue;
                int d = l - 17;
                int d2 = l - 16;
                ds = (d + d2) / 2;
                this.StompDamage(0.4f, d, 6, 0.9f, 0.0f, -1.3f, 80, 1.0f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.StompDamage(0.4f, d2, 6, 0.9f, 0.0f, -1.3f, 80, 1.0f, (float)CMConfig.RemnantStompHpDamage, 0.1f);
                this.Stompsound(ds, -1.3f);
            }
        }
        if (this.getAnimation() == REMNANT_DEATH && (this.getAnimationTick() == 52 || this.getAnimationTick() == 62 || this.getAnimationTick() == 77)) {
            ScreenShake_Entity.ScreenShake(this.level(), this.position(), 30.0f, 0.05f, 0, 8);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (item == ModItems.NECKLACE_OF_THE_DESERT.get() && !this.getIsAct()) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.setIsAct(true);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - this.getZ(), entityHit.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.yBodyRot % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - this.getZ()) * (entityHit.getZ() - this.getZ()) + (entityHit.getX() - this.getX()) * (entityHit.getX() - this.getX()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.isAlliedTo((Entity)entityHit) || entityHit instanceof Ancient_Ancient_Remnant_Entity || entityHit == this) continue;
            DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
            boolean flag = entityHit.hurt(damagesource, (float)(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (double)damage + Math.min(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (double)damage, (double)(entityHit.getMaxHealth() * hpdamage))));
            if (entityHit.isDamageSourceBlocked(damagesource) && entityHit instanceof Player) {
                Player player = (Player)entityHit;
                if (shieldbreakticks > 0) {
                    this.disableShield(player, shieldbreakticks);
                }
            }
            if (!flag || stunticks <= 0) continue;
            entityHit.addEffect(new MobEffectInstance(ModEffect.EFFECTSTUN, stunticks));
        }
    }

    private void TailAreaAttack(float range, float height, float height2, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks) {
        List<LivingEntity> entitiesHit = this.getTailEntityLivingBaseNearby(range, height, height2, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.getZ() - this.getZ(), entityHit.getX() - this.getX()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.yBodyRot % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.getZ() - this.getZ()) * (entityHit.getZ() - this.getZ()) + (entityHit.getX() - this.getX()) * (entityHit.getX() - this.getX()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.isAlliedTo((Entity)entityHit) || entityHit instanceof Ancient_Ancient_Remnant_Entity || entityHit == this) continue;
            DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
            boolean flag = entityHit.hurt(damagesource, (float)(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (double)damage + Math.min(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (double)damage, (double)(entityHit.getMaxHealth() * hpdamage))));
            if (entityHit.isDamageSourceBlocked(damagesource) && entityHit instanceof Player) {
                Player player = (Player)entityHit;
                if (shieldbreakticks > 0) {
                    this.disableShield(player, shieldbreakticks);
                }
            }
            if (!flag) continue;
            if (stunticks > 0) {
                entityHit.addEffect(new MobEffectInstance(ModEffect.EFFECTSTUN, stunticks));
            }
            double d0 = entityHit.getX() - this.getX();
            double d1 = entityHit.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            entityHit.push(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
        }
    }

    private void StompDamage(float spreadarc, int distance, int height, float mxy, float vec, float math, int shieldbreakticks, float damage, float hpdamage, float airborne) {
        double perpFacing = (double)this.yBodyRot * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.floor((double)(this.getBoundingBox().minY - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.ceil((double)((double)distance * spread));
        float f = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
        float f1 = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.getX() + vx * (double)distance + (double)vec * Math.cos((double)(this.yBodyRot + 90.0f) * Math.PI / 180.0) + (double)(f * math);
            double pz = this.getZ() + vz * (double)distance + (double)vec * Math.sin((double)(this.yBodyRot + 90.0f) * Math.PI / 180.0 + (double)(f1 * math));
            float factor = 1.0f - (float)distance / 12.0f;
            int hitX = Mth.floor((double)px);
            int hitZ = Mth.floor((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY + height, hitZ);
            BlockState block = this.level().getBlockState(pos);
            int maxDepth = 30;
            for (int depthCount = 0; depthCount < maxDepth && block.getRenderShape() != RenderShape.MODEL; ++depthCount) {
                pos = pos.below();
                block = this.level().getBlockState(pos);
            }
            if (block.getRenderShape() != RenderShape.MODEL) {
                block = Blocks.AIR.defaultBlockState();
            }
            this.spawnBlocks(hitX, hitY + height, hitZ, (int)(this.getY() - (double)height), block, px, pz, mxy, vx, vz, factor, shieldbreakticks, damage, hpdamage);
        }
    }

    private void spawnBlocks(int hitX, int hitY, int hitZ, int lowestYCheck, BlockState blockState, double px, double pz, float mxy, double vx, double vz, float factor, int shieldbreakticks, float damage, float hpdamage) {
        BlockPos blockpos = new BlockPos(hitX, hitY, hitZ);
        BlockState block = this.level().getBlockState(blockpos);
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = this.level().getBlockState(blockpos1);
            if (!blockstate.isFaceSturdy((BlockGetter)this.level(), blockpos1, Direction.UP)) continue;
            if (this.level().isEmptyBlock(blockpos) || (voxelshape = (blockstate1 = this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty()) break;
            d0 = voxelshape.max(Direction.Axis.Y);
            break;
        } while ((blockpos = blockpos.below()).getY() >= Mth.floor((float)lowestYCheck) - 1);
        Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.level(), (double)hitX + 0.5, (double)blockpos.getY() + d0 + 0.5, (double)hitZ + 0.5, blockState, 10);
        fallingBlockEntity.push(0.0, 0.2 + this.getRandom().nextGaussian() * 0.04, 0.0);
        this.level().addFreshEntity((Entity)fallingBlockEntity);
        AABB selection = new AABB(px - 0.5, (double)blockpos.getY() + d0 - 1.0, pz - 0.5, px + 0.5, (double)blockpos.getY() + d0 + (double)mxy, pz + 0.5);
        List hit = this.level().getEntitiesOfClass(LivingEntity.class, selection);
        for (LivingEntity entity : hit) {
            if (this.isAlliedTo((Entity)entity) || entity instanceof Ancient_Ancient_Remnant_Entity || entity == this) continue;
            DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
            boolean flag = entity.hurt(damagesource, (float)(this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (double)damage + (double)(entity.getMaxHealth() * hpdamage)));
            if (entity.isDamageSourceBlocked(damagesource) && entity instanceof Player) {
                Player player = (Player)entity;
                if (shieldbreakticks > 0) {
                    this.disableShield(player, shieldbreakticks);
                }
            }
            if (!flag) continue;
            double magnitude = -4.0;
            double x = vx * (double)(1.0f - factor) * magnitude;
            double y = 0.0;
            if (entity.onGround()) {
                y += 0.15;
            }
            double z = vz * (double)(1.0f - factor) * magnitude;
            entity.setDeltaMovement(entity.getDeltaMovement().add(x, y, z));
        }
    }

    private void Stompsound(float distance, float math) {
        double theta = (double)this.yBodyRot * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float f = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
        float f1 = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
        this.level().playLocalSound(this.getX() + (double)distance * vecX + (double)(f * math), this.getY(), this.getZ() + (double)distance * vecZ + (double)(f1 * math), (SoundEvent)ModSounds.REMNANT_SHOCKWAVE.get(), this.getSoundSource(), 1.5f, 0.8f + this.getRandom().nextFloat() * 0.1f, false);
    }

    public List<LivingEntity> getTailEntityLivingBaseNearby(double distanceX, double distanceMinY, double distanceMaxY, double distanceZ, double radius) {
        return this.getTailEntitiesNearby(LivingEntity.class, distanceX, distanceMinY, distanceMaxY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getTailEntitiesNearby(Class<T> entityClass, double dX, double dY, double pY, double dZ, double r) {
        return this.level().getEntitiesOfClass(entityClass, new AABB(this.getX() - dX, this.getY() - dY, this.getZ() - dZ, this.getX() + dX, this.getY() + pY, this.getZ() + dZ), e -> e != this && (double)this.distanceTo((Entity)e) <= r + (double)(e.getBbWidth() / 2.0f) && e.getY() <= this.getY() + dY);
    }

    private void StompParticle(float vec, float math) {
        if (this.level().isClientSide) {
            float f = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
            float f1 = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
            double theta = (double)this.yBodyRot * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (int i1 = 0; i1 < 80 + this.random.nextInt(12); ++i1) {
                double DeltaMovementX = this.getRandom().nextGaussian() * 0.07;
                double DeltaMovementY = this.getRandom().nextGaussian() * 0.07;
                double DeltaMovementZ = this.getRandom().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.yBodyRot + (float)i1;
                double extraX = 0.5 * (double)Mth.sin((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 0.5 * (double)Mth.cos((float)angle);
                int hitX = Mth.floor((double)(this.getX() + (double)vec * vecX + extraX));
                int hitY = Mth.floor((double)this.getY());
                int hitZ = Mth.floor((double)(this.getZ() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.level().getBlockState(hit.below());
                if (block.getRenderShape() == RenderShape.INVISIBLE) continue;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), this.getX() + (double)vec * vecX + extraX + (double)(f * math), this.getY() + extraY, this.getZ() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
            this.level().addParticle((ParticleOptions)new RingParticleOptions(0.0f, 1.5707964f, 20, 255, 255, 255, 1.0f, 25.0f, false, 2), this.getX() + (double)vec * vecX + (double)(f * math), this.getY() + (double)0.2f, this.getZ() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
        }
    }

    private void EarthQuakeSummon(float vec, int quake, float math) {
        float f = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
        float f1 = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
        double theta = (double)this.yBodyRot * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float angle = 360.0f / (float)quake;
        for (int i = 0; i < quake; ++i) {
            EarthQuake_Entity peq = new EarthQuake_Entity(this.level(), (LivingEntity)this);
            peq.setDamage((float)CMConfig.AncientRemnantEarthQuakeDamage);
            peq.shootFromRotation((Entity)this, 0.0f, angle * (float)i, 0.0f, 0.45f, 0.0f);
            peq.setPos(this.getX() + (double)vec * vecX + (double)(f * math), this.getY(), this.getZ() + (double)vec * vecZ + (double)(f1 * math));
            this.level().addFreshEntity((Entity)peq);
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.getIsAct() ? (SoundEvent)ModSounds.REMNANT_IDLE.get() : super.getAmbientSound();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.REMNANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.REMNANT_DEATH.get();
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)ModSounds.REMNANT_MUSIC.get();
    }

    @Override
    protected boolean canPlayMusic() {
        return super.canPlayMusic() && this.getIsAct();
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return REMNANT_DEATH;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    protected BodyRotationControl createBodyControl() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    private static enum AttackMode {
        CIRCLE,
        MELEE;

    }

    class RemnantAttackGoal
    extends Goal {
        private final Ancient_Ancient_Remnant_Entity mob;
        private LivingEntity target;
        private int circlingTime = 0;
        private final float huntingTime = 0.0f;
        private float circleDistance = 9.0f;
        private boolean clockwise = false;

        public RemnantAttackGoal(Ancient_Ancient_Remnant_Entity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.target = this.mob.getTarget();
            return this.target != null && this.target.isAlive() && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION;
        }

        public boolean canContinueToUse() {
            this.target = this.mob.getTarget();
            return this.target != null;
        }

        public void start() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0;
            this.circleDistance = 18 + this.mob.random.nextInt(10);
            this.clockwise = this.mob.random.nextBoolean();
            this.mob.setAggressive(true);
        }

        public void stop() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0;
            this.circleDistance = 18 + this.mob.random.nextInt(10);
            this.clockwise = this.mob.random.nextBoolean();
            this.target = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(this.target)) {
                this.mob.setTarget(null);
            }
            this.mob.getNavigation().stop();
            if (this.mob.getTarget() == null) {
                this.mob.setAggressive(false);
                this.mob.getNavigation().stop();
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity target = this.mob.getTarget();
            if (target != null) {
                if (this.mob.mode == AttackMode.CIRCLE) {
                    ++this.circlingTime;
                    Ancient_Ancient_Remnant_Entity.this.circleEntity((Entity)target, this.circleDistance, 1.0f, this.clockwise, this.circlingTime, 0.0f, 1.0f);
                    if (0.0f >= (float)this.mob.hunting_cooldown) {
                        this.mob.mode = AttackMode.MELEE;
                    } else if ((double)this.mob.distanceTo((Entity)target) < 4.0) {
                        this.mob.mode = AttackMode.MELEE;
                    }
                } else if (this.mob.mode == AttackMode.MELEE) {
                    this.mob.getNavigation().moveTo((Entity)target, 1.0);
                    this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                    if (this.mob.roar2_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 12.0f && target.getY() >= this.mob.getY() + 8.0 || this.mob.roar2_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 3.0f && (double)this.mob.distanceTo((Entity)target) > 12.0) {
                        this.mob.setAnimation(REMNANT_ROAR2);
                        this.mob.roar2_cooldown = 200;
                    } else if (this.mob.roar_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 3.0f) {
                        this.mob.setAnimation(REMNANT_ROAR);
                        this.mob.roar_cooldown = 500;
                    } else if (this.mob.earthquake_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 7.0f && (double)this.mob.distanceTo((Entity)target) < 12.0 && target.onGround()) {
                        this.mob.setAnimation(REMNANT_TAIL_THREE);
                        this.mob.earthquake_cooldown = 160;
                    } else if (this.mob.charge_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 9.0f && (double)this.mob.distanceTo((Entity)target) > 7.0 && (double)this.mob.distanceTo((Entity)target) < 20.0 && target.getY() <= this.mob.getY() + 1.0) {
                        if (this.mob.random.nextBoolean()) {
                            this.mob.setAnimation(REMNANT_RIGHT_STOMP);
                        } else {
                            this.mob.setAnimation(REMNANT_LEFT_STOMP);
                        }
                    } else if (this.mob.charge_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 3.0f && (double)this.mob.distanceTo((Entity)target) > 12.0) {
                        this.mob.setAnimation(REMNANT_CHARGE_PREPARE);
                        this.mob.charge_cooldown = 250;
                    } else if (this.mob.charge_cooldown <= 0 && this.mob.getRandom().nextFloat() * 100.0f < 9.0f && (double)this.mob.distanceTo((Entity)target) > 7.0 && (double)this.mob.distanceTo((Entity)target) < 20.0 && target.getY() <= this.mob.getY() + 4.5) {
                        if (this.mob.random.nextBoolean()) {
                            this.mob.setAnimation(REMNANT_RIGHT_STOMP);
                        } else {
                            this.mob.setAnimation(REMNANT_LEFT_STOMP);
                        }
                        this.mob.stomp_cooldown = 200;
                    } else if (this.mob.getRandom().nextFloat() * 100.0f < 10.0f && (double)this.mob.distanceTo((Entity)target) < 7.0 && target.getY() < this.mob.getY() + 1.0) {
                        this.mob.setAnimation(REMNANT_TAIL_ATTACK1);
                    } else if (this.mob.getRandom().nextFloat() * 100.0f < 10.0f && (double)this.mob.distanceTo((Entity)target) < 6.0) {
                        if (this.mob.random.nextBoolean()) {
                            this.mob.setAnimation(REMNANT_BITE1);
                        } else {
                            this.mob.setAnimation(REMNANT_BITE2);
                        }
                    }
                }
            }
        }
    }

    class AwakenGoal
    extends Goal {
        public AwakenGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return Ancient_Ancient_Remnant_Entity.this.activeProgress > 0.0f;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            Ancient_Ancient_Remnant_Entity.this.setDeltaMovement(0.0, Ancient_Ancient_Remnant_Entity.this.getDeltaMovement().y, 0.0);
        }
    }

    static class RemnantChargeAttackGoal
    extends SimpleAnimationGoal<Ancient_Ancient_Remnant_Entity> {
        public RemnantChargeAttackGoal(Ancient_Ancient_Remnant_Entity entity, Animation animation) {
            super(entity, animation);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public void start() {
            ((Ancient_Ancient_Remnant_Entity)this.entity).getNavigation().stop();
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).lookAt((Entity)target, 30.0f, 30.0f);
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            super.start();
        }

        public void stop() {
            super.stop();
            ((Ancient_Ancient_Remnant_Entity)this.entity).hunting_cooldown = 100;
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).lookAt((Entity)target, 30.0f, 30.0f);
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
        }

        public void tick() {
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() < 62 && target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).lookAt((Entity)target, 30.0f, 30.0f);
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Ancient_Remnant_Entity)this.entity).setYRot(((Ancient_Ancient_Remnant_Entity)this.entity).yRotO);
            }
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() < 122 && ((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() > 62 && ((Ancient_Ancient_Remnant_Entity)this.entity).onGround()) {
                Vec3 vector3d = ((Ancient_Ancient_Remnant_Entity)this.entity).getDeltaMovement();
                float f = ((Ancient_Ancient_Remnant_Entity)this.entity).getYRot() * ((float)Math.PI / 180);
                Vec3 vector3d1 = new Vec3((double)(-Mth.sin((float)f)), ((Ancient_Ancient_Remnant_Entity)this.entity).getDeltaMovement().y, (double)Mth.cos((float)f)).scale(1.0).add(vector3d.scale(0.5));
                ((Ancient_Ancient_Remnant_Entity)this.entity).setDeltaMovement(vector3d1.x, ((Ancient_Ancient_Remnant_Entity)this.entity).getDeltaMovement().y, vector3d1.z);
            }
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() == 62) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).setIsCharge(true);
            }
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() == 122) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).setIsCharge(false);
            }
        }
    }

    static class RemnantAnimationAttackGoal
    extends SimpleAnimationGoal<Ancient_Ancient_Remnant_Entity> {
        private final int look;

        public RemnantAnimationAttackGoal(Ancient_Ancient_Remnant_Entity entity, Animation animation, int look) {
            super(entity, animation);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.look = look;
        }

        public void start() {
            ((Ancient_Ancient_Remnant_Entity)this.entity).getNavigation().stop();
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).lookAt((Entity)target, 30.0f, 30.0f);
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            super.start();
        }

        public void tick() {
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() < this.look && target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).lookAt((Entity)target, 30.0f, 30.0f);
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Ancient_Remnant_Entity)this.entity).setYRot(((Ancient_Ancient_Remnant_Entity)this.entity).yRotO);
            }
        }
    }

    static class RemnantSteleAttackGoal
    extends SimpleAnimationGoal<Ancient_Ancient_Remnant_Entity> {
        private final int look;

        public RemnantSteleAttackGoal(Ancient_Ancient_Remnant_Entity entity, Animation animation, int look) {
            super(entity, animation);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.look = look;
        }

        public void start() {
            ((Ancient_Ancient_Remnant_Entity)this.entity).getNavigation().stop();
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            super.start();
        }

        public void tick() {
            LivingEntity target = ((Ancient_Ancient_Remnant_Entity)this.entity).getTarget();
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() < this.look && target != null) {
                ((Ancient_Ancient_Remnant_Entity)this.entity).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Ancient_Remnant_Entity)this.entity).setYRot(((Ancient_Ancient_Remnant_Entity)this.entity).yRotO);
            }
            if (((Ancient_Ancient_Remnant_Entity)this.entity).getAnimationTick() == this.look && target != null) {
                float f4;
                int k;
                double d1 = target.getY();
                float f = (float)Mth.atan2((double)(target.getZ() - ((Ancient_Ancient_Remnant_Entity)this.entity).getZ()), (double)(target.getX() - ((Ancient_Ancient_Remnant_Entity)this.entity).getX()));
                for (k = 0; k < 10; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 10.0f + 0.41887903f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 4.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 4.5, d1, f4, 10);
                }
                for (k = 0; k < 12; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 12.0f + 0.31415927f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 7.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 7.5, d1, f4, 15);
                }
                for (k = 0; k < 14; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 17.0f + 0.20943952f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 10.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 10.5, d1, f4, 20);
                }
                for (k = 0; k < 16; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 16.0f + 0.15707964f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 13.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 13.5, d1, f4, 25);
                }
                for (k = 0; k < 18; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 18.0f + 0.10471976f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 16.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 16.5, d1, f4, 30);
                }
                for (k = 0; k < 20; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 20.0f + 0.07853982f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 19.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 19.5, d1, f4, 35);
                }
                for (k = 0; k < 22; ++k) {
                    f4 = f + (float)k * (float)Math.PI * 2.0f / 22.0f + 0.05235988f;
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f4) * 22.5, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f4) * 22.5, d1, f4, 40);
                }
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = (int)(5.0f + 1.5f * (float)l);
                    this.spawnSpikeLine(((Ancient_Ancient_Remnant_Entity)this.entity).getX() + (double)Mth.cos((float)f) * d2, ((Ancient_Ancient_Remnant_Entity)this.entity).getZ() + (double)Mth.sin((float)f) * d2, d1, f, j);
                }
            }
        }

        private void spawnSpikeLine(double posX, double posZ, double posY, float rotation, int delay) {
            BlockPos blockpos = BlockPos.containing((double)posX, (double)posY, (double)posZ);
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.above();
                BlockState blockstate = ((Ancient_Ancient_Remnant_Entity)this.entity).level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)((Ancient_Ancient_Remnant_Entity)this.entity).level(), blockpos1, Direction.DOWN)) continue;
                if (((Ancient_Ancient_Remnant_Entity)this.entity).level().isEmptyBlock(blockpos) || (voxelshape = (blockstate1 = ((Ancient_Ancient_Remnant_Entity)this.entity).level().getBlockState(blockpos)).getCollisionShape((BlockGetter)((Ancient_Ancient_Remnant_Entity)this.entity).level(), blockpos)).isEmpty()) break;
                d0 = voxelshape.max(Direction.Axis.Y);
                break;
            } while ((blockpos = blockpos.above()).getY() < Math.min(((Ancient_Ancient_Remnant_Entity)this.entity).level().getMaxBuildHeight(), ((Ancient_Ancient_Remnant_Entity)this.entity).getBlockY() + 20));
            ((Ancient_Ancient_Remnant_Entity)this.entity).level().addFreshEntity((Entity)new Ancient_Desert_Stele_Entity(((Ancient_Ancient_Remnant_Entity)this.entity).level(), posX, (double)blockpos.getY() + d0 - 3.0, posZ, rotation, delay, (float)CMConfig.AncientDesertSteledamage, (LivingEntity)this.entity));
        }
    }
}

